/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.font.Emojis;
import org.figuramc.figura.lua.api.action_wheel.Action;
import org.figuramc.figura.lua.api.action_wheel.Page;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class ActionWheel {
    private static final ResourceLocation TEXTURE = new FiguraIdentifier("textures/gui/action_wheel.png");
    private static final ResourceLocation ICONS = new FiguraIdentifier("textures/gui/action_wheel_icons.png");
    private static final double DISTANCE = 41.0;
    private static final double DEADZONE = 19.0;
    private static boolean enabled = false;
    private static int selected = -1;
    private static Minecraft minecraft;
    private static int slots;
    private static int leftSlots;
    private static int rightSlots;
    private static float scale;
    private static int x;
    private static int y;
    private static double mouseX;
    private static double mouseY;

    public static void render(GuiGraphics gui) {
        Page currentPage;
        if (!ActionWheel.isEnabled()) {
            return;
        }
        minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        x = (int)((double)window.getGuiScaledWidth() / 2.0);
        y = (int)((double)window.getGuiScaledHeight() / 2.0);
        PoseStack pose = gui.pose();
        pose.pushPose();
        pose.translate((double)x, (double)y, 0.0);
        scale = ((Float)Configs.ACTION_WHEEL_SCALE.value).floatValue();
        pose.scale(scale, scale, scale);
        Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        if (avatar == null || avatar.luaRuntime == null || (currentPage = avatar.luaRuntime.action_wheel.currentPage) == null) {
            ActionWheel.renderEmpty(gui, avatar == null);
            return;
        }
        slots = currentPage.getSize();
        leftSlots = (int)Math.floor((double)slots / 2.0);
        rightSlots = (int)Math.ceil((double)slots / 2.0);
        mouseX = ActionWheel.minecraft.mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        mouseY = ActionWheel.minecraft.mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
        FiguraMod.pushProfiler("selectedSlot");
        ActionWheel.calculateSelected();
        FiguraMod.popPushProfiler("wheel");
        ActionWheel.renderTextures(gui, currentPage);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FiguraMod.popPushProfiler("items");
        ActionWheel.renderItemsAndIcons(gui, currentPage);
        pose.popPose();
        FiguraMod.popPushProfiler("texts");
        ActionWheel.renderTexts(gui, currentPage);
        FiguraMod.popProfiler();
    }

    private static double getAngle(int i) {
        double angle = i < rightSlots ? 180.0 / (double)rightSlots * ((double)i - (double)(rightSlots - 1) * 0.5) : 180.0 / (double)leftSlots * (double)((float)(i - rightSlots) - (float)(leftSlots - 1) * 0.5f + (float)leftSlots);
        return Math.toRadians(angle);
    }

    private static void renderEmpty(GuiGraphics gui, boolean avatar) {
        TextureData data = OverlayTexture.values()[0].data[0];
        data.render(gui, null, false);
        data.render(gui, null, true);
        gui.pose().popPose();
        MutableComponent component = FiguraText.of("gui.error." + (avatar ? "no_avatar" : "no_wheel_page")).withStyle(ChatFormatting.YELLOW);
        Font font = ActionWheel.minecraft.font;
        int n = x - font.width((FormattedText)component) / 2;
        Objects.requireNonNull(font);
        UIHelper.renderOutlineText(gui, font, (Component)component, n, y - 9 / 2, 0xFFFFFF, 0);
    }

    private static void calculateSelected() {
        double mouseDistance = Math.sqrt(Math.pow((double)x - mouseX, 2.0) + Math.pow((double)y - mouseY, 2.0));
        if (rightSlots == 0 || mouseDistance < 19.0 * (double)scale) {
            selected = -1;
            return;
        }
        double angle = Math.toDegrees(Math.atan2(mouseY - (double)y, mouseX - (double)x)) + 90.0;
        if (angle < 0.0) {
            angle += 360.0;
        }
        selected = angle < 180.0 ? (int)Math.floor((double)rightSlots / 180.0 * angle) : (int)Math.floor((double)leftSlots / 180.0 * (angle - 180.0)) + rightSlots;
    }

    private static void renderTextures(GuiGraphics gui, Page page) {
        for (int i = 0; i < slots; ++i) {
            int relativeIndex;
            Action action = page.slots()[i];
            boolean left = i >= rightSlots;
            int type = left ? leftSlots : rightSlots;
            int n = relativeIndex = left ? i - rightSlots : i;
            FiguraVec3 color = action == null ? null : action.getColor(selected == i);
            OverlayTexture.values()[type - 1].data[relativeIndex].render(gui, color, left);
            if (action == null) continue;
            double angle = ActionWheel.getAngle(i);
            double x = Math.cos(angle) * 15.0 - 4.0;
            double y = Math.sin(angle) * 15.0 - 4.0;
            UIHelper.enableBlend();
            if (color != null) {
                RenderSystem.setShaderColor((float)((float)color.x), (float)((float)color.y), (float)((float)color.z), (float)1.0f);
            }
            gui.blit(ICONS, (int)Math.round(x), (int)Math.round(y), 8, 8, action.scroll != null ? 24.0f : (action.toggle != null ? (action.isToggled() ? 16.0f : 8.0f) : 0.0f), color == null ? 0.0f : 8.0f, 8, 8, 32, 16);
        }
    }

    private static void renderItemsAndIcons(GuiGraphics gui, Page page) {
        for (int i = 0; i < slots; ++i) {
            ItemStack item;
            Action action = page.slots()[i];
            if (action == null) continue;
            boolean isSelected = selected == i;
            double angle = ActionWheel.getAngle(i);
            double xOff = Math.cos(angle) * 41.0;
            double yOff = Math.sin(angle) * 41.0;
            Action.TextureData texture = action.getTexture(isSelected);
            if (texture != null) {
                UIHelper.enableBlend();
                gui.blit(texture.texture.getLocation(), (int)Math.round(xOff - (double)texture.width * texture.scale / 2.0), (int)Math.round(yOff - (double)texture.height * texture.scale / 2.0), (int)Math.round((double)texture.width * texture.scale), (int)Math.round((double)texture.height * texture.scale), (float)texture.u, (float)texture.v, texture.width, texture.height, texture.texture.getWidth(), texture.texture.getHeight());
            }
            if ((item = action.getItem(isSelected)) == null || item.isEmpty()) continue;
            gui.renderItem(item, (int)Math.round(xOff - 8.0), (int)Math.round(yOff - 8.0));
            if (!((Boolean)Configs.ACTION_WHEEL_DECORATIONS.value).booleanValue()) continue;
            gui.renderItemDecorations(ActionWheel.minecraft.font, item, (int)Math.round(xOff - 8.0), (int)Math.round(yOff - 8.0));
        }
    }

    private static void renderTexts(GuiGraphics gui, Page page) {
        Font font = ActionWheel.minecraft.font;
        int titlePosition = (Integer)Configs.ACTION_WHEEL_TITLE.value;
        int indicatorPosition = (Integer)Configs.ACTION_WHEEL_SLOTS_INDICATOR.value;
        PoseStack pose = gui.pose();
        Action selectedTitleAction = selected == -1 ? null : page.slots()[selected];
        String selectedTitle = selectedTitleAction == null ? null : selectedTitleAction.getTitle();
        int groupCount = page.getGroupCount();
        if (groupCount > 1 && (selectedTitle == null || indicatorPosition != titlePosition - 2)) {
            MutableComponent arrow;
            pose.pushPose();
            pose.translate(0.0, 0.0, 999.0);
            int index = page.getSlotsShift();
            int greatest = page.getGreatestSlot() + 1;
            MutableComponent indicator = Component.empty();
            int extraWidth = 0;
            if (index > 1) {
                arrow = UIHelper.UP_ARROW.copy().append(" ");
                indicator.append((Component)arrow);
                extraWidth -= font.width((FormattedText)arrow);
            }
            indicator.append((Component)FiguraText.of("gui.action_wheel.slots_indicator", Component.literal((String)String.valueOf((index - 1) * 8 + 1)).withStyle(FiguraMod.getAccentColor()), Component.literal((String)String.valueOf(Math.min(index * 8, greatest))).withStyle(FiguraMod.getAccentColor()), Component.literal((String)String.valueOf(greatest)).withStyle(FiguraMod.getAccentColor())));
            if (index < groupCount) {
                arrow = Component.literal((String)" ").append(UIHelper.DOWN_ARROW);
                indicator.append((Component)arrow);
                extraWidth += font.width((FormattedText)arrow);
            }
            int n = x - (int)((float)(font.width((FormattedText)indicator) - extraWidth) / 2.0f);
            Position position = Position.index(indicatorPosition);
            Objects.requireNonNull(font);
            gui.drawString(font, (Component)indicator, n, (int)position.apply(9.0), 0xFFFFFF);
            pose.popPose();
        }
        if (titlePosition >= 5) {
            boolean internal = titlePosition == 5;
            double distance = (internal ? 41.0 : 66.0) * (double)scale;
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 999.0f);
            for (int i = 0; i < slots; ++i) {
                float f;
                String title;
                Action action = page.slots()[i];
                if (action == null || (title = action.getTitle()) == null) continue;
                double angle = ActionWheel.getAngle(i);
                double xOff = Math.cos(angle) * distance;
                double yOff = Math.sin(angle) * distance;
                int textX = x + (int)Math.round(xOff);
                if (internal) {
                    f = 9.0f * scale;
                } else {
                    Objects.requireNonNull(font);
                    f = (float)(-9) / 2.0f;
                }
                int textY = y + (int)Math.round(yOff + (double)f);
                Component text = TextUtils.replaceInText((FormattedText)Emojis.applyEmojis(TextUtils.tryParseJson(title)), "\n|\\\\n", " ");
                int textWidth = font.width((FormattedText)text);
                if (internal) {
                    textX = (int)((float)textX - (float)textWidth / 2.0f);
                    textX = i >= rightSlots ? Math.min(textX, x - textWidth - 1) : Math.max(textX, x + 1);
                } else if (i >= rightSlots) {
                    textX -= textWidth;
                }
                gui.drawString(font, text, textX, textY, 0xFFFFFF);
            }
            pose.popPose();
            return;
        }
        if (selectedTitle == null) {
            return;
        }
        MutableComponent text = Emojis.applyEmojis(TextUtils.tryParseJson(selectedTitle));
        List<Component> list = TextUtils.splitText((FormattedText)text, "\n");
        Objects.requireNonNull(font);
        int height = 9 * list.size();
        if (titlePosition < 2) {
            UIHelper.renderTooltip(gui, (Component)text, (int)mouseX, (int)mouseY, titlePosition == 0);
        } else {
            pose.pushPose();
            pose.translate(0.0, 0.0, 999.0);
            int y = (int)Position.index(titlePosition - 2).apply(height);
            for (int i = 0; i < list.size(); ++i) {
                Component component = list.get(i);
                int n = x - (int)((float)font.width((FormattedText)component) / 2.0f);
                Objects.requireNonNull(font);
                gui.drawString(font, component, n, y + 9 * i, 0xFFFFFF);
            }
            pose.popPose();
        }
    }

    public static void execute(int index, boolean left) {
        Page currentPage;
        Avatar avatar;
        if (!ActionWheel.isEnabled() || (avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID())) == null || avatar.luaRuntime == null) {
            selected = -1;
            return;
        }
        if (avatar.luaRuntime.action_wheel.execute(avatar, left)) {
            return;
        }
        if (index < 0 || index > 7 || avatar.luaRuntime == null || (currentPage = avatar.luaRuntime.action_wheel.currentPage) == null) {
            selected = -1;
            return;
        }
        Action action = currentPage.slots()[index];
        if (action != null) {
            action.execute(avatar, left);
        }
        selected = -1;
    }

    public static void hotbarKeyPressed(int i) {
        ActionWheel.execute(i, true);
    }

    public static void scroll(double delta) {
        Action action;
        Page currentPage;
        Avatar avatar;
        if (!ActionWheel.isEnabled() || (avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID())) == null || avatar.luaRuntime == null) {
            return;
        }
        if (avatar.luaRuntime.action_wheel.mouseScroll(avatar, delta)) {
            return;
        }
        if (avatar.luaRuntime == null || (currentPage = avatar.luaRuntime.action_wheel.currentPage) == null) {
            return;
        }
        if (selected >= 0 && selected <= 7 && (action = currentPage.slots()[selected]) != null && action.scroll != null) {
            action.mouseScroll(avatar, delta);
            return;
        }
        currentPage.setSlotsShift(currentPage.getSlotsShift() - (int)Math.signum(delta));
    }

    public static void setEnabled(boolean enabled) {
        ActionWheel.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static int getSelected() {
        return selected;
    }

    private static enum OverlayTexture {
        ONE(new TextureData(true, -64, 0.0f, 0.0f, 0)),
        TWO(new TextureData(64.0f, 0.0f), new TextureData(64.0f, 0.0f, 90)),
        THREE(new TextureData(128.0f, 0.0f), new TextureData(-32, 128.0f, 64.0f, 0), new TextureData(0, 64.0f, 64.0f, 0)),
        FOUR(new TextureData(192.0f, 0.0f), new TextureData(192.0f, 64.0f), new TextureData(192.0f, 0.0f, 90), new TextureData(192.0f, 64.0f, 90));

        private final TextureData[] data;

        private OverlayTexture(TextureData ... data) {
            this.data = data;
        }
    }

    private static class TextureData {
        private final int y;
        private final int h;
        private final int rh;
        private final float u;
        private final float v;
        private final int rotation;

        public TextureData(boolean large, int y, float u, float v, int rotation) {
            this.y = y;
            this.h = large ? 128 : 64;
            this.u = u;
            this.v = v;
            this.rh = large ? 128 : 64;
            this.rotation = rotation;
        }

        public TextureData(int y, float u, float v, int rotation) {
            this(false, y, u, v, rotation);
        }

        public TextureData(float u, float v, int rotation) {
            this(-64, u, v, rotation);
        }

        public TextureData(float u, float v) {
            this(u, v, 0);
        }

        public void render(GuiGraphics gui, FiguraVec3 color, boolean left) {
            PoseStack pose = gui.pose();
            pose.pushPose();
            pose.mulPose(Axis.ZP.rotationDegrees((float)(this.rotation + (left ? 180 : 0))));
            UIHelper.enableBlend();
            if (color != null) {
                gui.setColor((float)color.x, (float)color.y, (float)color.z, 1.0f);
            }
            gui.blit(TEXTURE, 0, this.y, 64, this.h, this.u, color == null ? this.v : this.v + 128.0f, 64, this.rh, 256, 256);
            pose.popPose();
        }
    }

    private static enum Position {
        TOP(height -> Math.max((double)((float)y - 64.0f * scale - 4.0f) - height, 4.0)),
        MID(height -> (double)y - height / 2.0),
        BOT(height -> Math.min((double)((float)y + 64.0f * scale + 4.0f) + height, (double)(y * 2 - 4)) - height);

        private final Function<Double, Double> function;

        private Position(Function<Double, Double> function) {
            this.function = function;
        }

        public static Position index(int i) {
            return Position.values()[i];
        }

        public double apply(double d) {
            return this.function.apply(d);
        }
    }
}

